(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3085,         92]*)
(*NotebookOutlinePosition[      3785,        116]*)
(*  CellTagsIndexPosition[      3741,        112]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(g1 = 
        Plot3D[Boole[
              x^2 + \((y - 2)\)^2 < 
                3] \((x^2 + \((y - 1)\)^2)\), {x, \(-\@3\), \@3}, {y, 
            2 - \@3, 2 + \@3}, Boxed \[Rule] False, Axes -> False, 
          PlotPoints \[Rule] 120, BoxRatios \[Rule] {1, 1, 1}];\)\)], "Input"],

Cell[BoxData[
    \(\(g2 = 
        ParametricPlot3D[{\(\@3\) Cos[t], 2 + \(\@3\) Sin[t], 
            4 + 2 \(\@ 3\) Sin[t], {Hue[ .16], Thickness[0.016]}}, {t, 0, 
            2  Pi}];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[g1, g2];\)\)], "Input"],

Cell[BoxData[{
    \(\(\[Gamma][s_, t_] = {\(\@3\) s\ Cos[t], 2 + \(\@3\) s\ Sin[t], 
          4 + 2 \(\@ 3\) s\ Sin[t]};\)\), "\[IndentingNewLine]", 
    \(Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]] // 
      Simplify\)}], "Input"],

Cell[BoxData[
    \(<< Calculus`VectorAnalysis`\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_, z_] = {y, x, x\ z};\)\), "\[IndentingNewLine]", 
    \(h[x_, y_, z_] = Curl[F[x, y, z], Cartesian[x, y, z]]\)}], "Input"],

Cell[BoxData[
    \(Apply[h, \[Gamma][s, t]] . 
        Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]] // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(Integrate[%, {s, 0, 1}, {t, 0, 2  Pi}]\)], "Input"],

Cell[BoxData[
    \(Apply[h, \[Gamma][s, t]] . {0, \(-2\), 1} // Simplify\)], "Input"]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 304, 6, 165, "Input"],
Cell[2061, 59, 201, 4, 108, "Input"],
Cell[2265, 65, 50, 1, 94, "Input"],
Cell[2318, 68, 240, 4, 128, "Input"],
Cell[2561, 74, 60, 1, 94, "Input"],
Cell[2624, 77, 154, 2, 120, "Input"],
Cell[2781, 81, 137, 3, 94, "Input"],
Cell[2921, 86, 71, 1, 94, "Input"],
Cell[2995, 89, 86, 1, 94, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

